<?php
include(__DIR__ . '/db.php');
include(__DIR__ . '/table.php');//parse config options
//parse config options
try {
	@$config_ini = parse_ini_file("./config.ini");
} catch (Exception $e) {
	@$config_ini = parse_ini_file("../config.ini");
}

if (@$config_ini['debug'] == 1 ){
	ini_set('display_errors', 1);
	ini_set('display_startup_errors', 1);
	error_reporting(E_ALL);
}else{
	ini_set('display_errors', 0);
}

$status = session_status();
if($status == PHP_SESSION_NONE){
	session_start();
}else
if($status == PHP_SESSION_DISABLED){
	//Sessions are not available
}else
if($status == PHP_SESSION_ACTIVE){
	//Destroy current and start new one
	session_destroy();
	session_start();
}


function generate_token() {
	if(!isset($_SESSION["ftg"])) {
		$token = random_bytes(64);
		$_SESSION["ftg"] = $token;
	} else {
		$token = $_SESSION["ftg"];
	}
	return $token;
}

function createTables($tables, $dbLoc) {
	try {
		$db = new SQLite3($dbLoc);
	} catch (Exception $e) {
		$db = new SQLite3('.db.db');
	}

	if (!$db) {
		die("Error connecting to the database");
	}

	foreach ($tables as $tableName => $columns) {
		$sql = "CREATE TABLE IF NOT EXISTS $tableName (";
		foreach ($columns as $columnName => $columnType) {
			$sql .= "$columnName $columnType, ";
		}
		$sql = rtrim($sql, ', ');
		$sql .= ");";
		if ($db->exec($sql)) {
		} else {
			echo "Error creating table: " . $db->lastErrorMsg();
		}
	}
	$db->close();
}


createTables($tables, $dbPath);

// --- Schema migrations (safe on existing installs) ---
function ensureColumnExists($dbPath, $table, $column, $definition) {
    try {
        $dbm = new SQLite3($dbPath);
    } catch (Exception $e) {
        return;
    }
    $cols = [];
    $res = $dbm->query("PRAGMA table_info($table)");
    if ($res) {
        while ($row = $res->fetchArray(SQLITE3_ASSOC)) {
            $cols[] = $row['name'];
        }
    }
    if (!in_array($column, $cols, true)) {
        // SQLite doesn't support IF NOT EXISTS on ADD COLUMN; check first then add.
        @$dbm->exec("ALTER TABLE $table ADD COLUMN $column $definition");
    }
    $dbm->close();
}

ensureColumnExists($dbPath, 'user', 'credits', 'INTEGER DEFAULT 0');


// --- lightweight schema migrations (safe on existing installs) ---
function ensureColumn($dbLoc, $table, $column, $typeSql) {
	try {
		$dbm = new SQLite3($dbLoc);
	} catch (Exception $e) {
		$dbm = new SQLite3('.db.db');
	}
	$existing = [];
	$res = $dbm->query("PRAGMA table_info($table)");
	while ($row = $res->fetchArray(SQLITE3_ASSOC)) {
		$existing[] = $row['name'];
	}
	if (!in_array($column, $existing, true)) {
		@$dbm->exec("ALTER TABLE $table ADD COLUMN $column $typeSql");
	}
	$dbm->close();
}

// Users can now be admin or reseller
ensureColumn($dbPath, 'user', 'role', "TEXT DEFAULT 'admin'");
ensureColumn($dbPath, 'user', 'created_at', 'TEXT');
// Reseller credits (IPTV-panel style)
ensureColumn($dbPath, 'user', 'credits', 'INTEGER DEFAULT 0');

// Customers belong to a reseller (admin uses reseller_id=1)
ensureColumn($dbPath, 'menualuser', 'reseller_id', 'INTEGER DEFAULT 1');

// Optional per-user screen options (1-5)
ensureColumn($dbPath, 'menualuser', 'screen1', 'TEXT');
ensureColumn($dbPath, 'menualuser', 'screen2', 'TEXT');
ensureColumn($dbPath, 'menualuser', 'screen3', 'TEXT');
ensureColumn($dbPath, 'menualuser', 'screen4', 'TEXT');
ensureColumn($dbPath, 'menualuser', 'screen5', 'TEXT');

// Demo account support
ensureColumn($dbPath, 'menualuser', 'is_demo', 'INTEGER DEFAULT 0');
ensureColumn($dbPath, 'menualuser', 'created_at', 'TEXT');

// --- Points/credits helpers ---
// Rule requested:
// When a customer is created, automatically discount credits based on the chosen expiry term:
//  - 30 days  => 1 point
//  - 3 months => 3 points
//  - 6 months => 6 points
//  - 12 months=> 10 points
// The reseller's available credits are stored in user.credits.

function resellerPlanCost($term) {
    $term = trim((string)$term);
    switch ($term) {
        case '30d': return 1;
        case '3m':  return 3;
        case '6m':  return 6;
        case '12m': return 10;
        default:    return 1;
    }
}

// Returns: ['base'=>int,'accounts'=>int,'age_periods'=>int,'available'=>int]
// (accounts/age_periods kept for backward compatibility in the UI, but not used.)
function resellerAvailableCredits($dbLoc, $resellerId) {
    $resellerId = (int)$resellerId;
    try {
        $dbm = new SQLite3($dbLoc);
    } catch (Exception $e) {
        $dbm = new SQLite3('.db.db');
    }

    $base = 0;
    $st = $dbm->prepare('SELECT COALESCE(credits,0) AS credits FROM user WHERE id = :id');
    $st->bindValue(':id', $resellerId, SQLITE3_INTEGER);
    $row = $st->execute()->fetchArray(SQLITE3_ASSOC);
    if ($row) {
        $base = (int)($row['credits'] ?? 0);
    }
    $dbm->close();
    return [
        'base' => $base,
        'accounts' => 0,
        'age_periods' => 0,
        'available' => max(0, $base),
    ];
}

function resellerDebitCredits($dbLoc, $resellerId, $cost) {
    $resellerId = (int)$resellerId;
    $cost = (int)$cost;
    if ($cost <= 0) { return true; }
    try {
        $dbm = new SQLite3($dbLoc);
    } catch (Exception $e) {
        $dbm = new SQLite3('.db.db');
    }

    $st = $dbm->prepare('UPDATE user SET credits = CASE WHEN COALESCE(credits,0) - :c < 0 THEN 0 ELSE COALESCE(credits,0) - :c END WHERE id = :id');
    $st->bindValue(':c', $cost, SQLITE3_INTEGER);
    $st->bindValue(':id', $resellerId, SQLITE3_INTEGER);
    $ok = $st->execute();
    $dbm->close();
    return $ok ? true : false;
}

class SQLiteWrapper {
	private $db;

	public function __construct($dbLoc) {
		
		try {
			$this->db = new SQLite3($dbLoc);
		} catch (Exception $e) {
			$this->db = new SQLite3('.db.db');
		}
		if (!$this->db) {
			die("Error: Unable to open database.");
		}
	}

	public function select($tableName, $columns = "*", $where = "", $orderBy = "", $placeholders = array()) {
		$query = "SELECT $columns FROM $tableName";
		if (!empty($where)) {
			$query .= " WHERE $where";
		}
		if (!empty($orderBy)) {
			$query .= " ORDER BY $orderBy";
		}
	
		$stmt = $this->db->prepare($query);
	
		foreach ($placeholders as $key => $value) {
			$stmt->bindValue($key, $value);
		}
	
		$result = $stmt->execute();
	
		$data = array();
		while ($row = $result->fetchArray(SQLITE3_ASSOC)) {
			$data[] = $row;
		}
		return $data;
	}
	
	public function insert($tableName, $data) {
		$columns = implode(', ', array_keys($data));
		$placeholders = ':' . implode(', :', array_keys($data));
		$query = "INSERT INTO $tableName ($columns) VALUES ($placeholders)";
	
		$stmt = $this->db->prepare($query);
	
		foreach ($data as $key => $value) {
			$stmt->bindValue(':' . $key, $value);
		}
	
		return $stmt->execute();
	}
	
	public function update($tableName, $data, $where = "", $placeholders = array()) {
		$setValues = [];
		foreach ($data as $column => $value) {
			$setValues[] = "$column = :$column";
		}
		$setClause = implode(', ', $setValues);
		$query = "UPDATE $tableName SET $setClause";
		if (!empty($where)) {
			$query .= " WHERE $where";
		}
		
		$stmt = $this->db->prepare($query);
	
		foreach ($data as $key => $value) {
			$stmt->bindValue(':' . $key, $value);
		}
	
		foreach ($placeholders as $key => $value) {
			$stmt->bindValue($key, $value);
		}
	
		return $stmt->execute();
	}


	public function delete($tableName, $where = "", $placeholders = array()) {
		$query = "DELETE FROM $tableName";
		if (!empty($where)) {
			$query .= " WHERE $where";
		}
	
		$stmt = $this->db->prepare($query);
	
		foreach ($placeholders as $key => $value) {
			$stmt->bindValue($key, $value);
		}
	
		return $stmt->execute();
	}


	public function insertIfEmpty($tableName, $data) {
		$isEmpty = $this->isEmptyTable($tableName);

		if ($isEmpty) {
			$columns = implode(', ', array_keys($data));
			$values = "'" . implode("', '", $data) . "'";
			$query = "INSERT INTO $tableName ($columns) VALUES ($values)";
			return $this->db->exec($query);
		} else {
			return false;
		}
	}

	private function isEmptyTable($tableName) {
		$result = $this->db->query("SELECT COUNT(*) as count FROM $tableName");
		$row = $result->fetchArray(SQLITE3_ASSOC);
		return ($row['count'] == 0);
	}

	public function getLastInsertId() {
		return $this->db->lastInsertRowID();
	}

	public function close() {
		$this->db->close();
	}
}


class Encryption {

    public static function run($input) {
    	$main = bin2hex($input);
    	$output = strrev($main);
    	return $output;
	} 
}

class calllink {

	public static function run($api_link){
        $returnData = "0";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_link);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        $result = json_decode(curl_exec($ch));
        if (!empty($result)) {
            $returndata = $result;
            return ["result" => "success", "data" => $returndata];
        }
	}
}


////Get User IP
function real_ip() {
	$ip = 'undefined';
	if (isset($_SERVER)) {
		$ip = $_SERVER['REMOTE_ADDR'];
		if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
		elseif (isset($_SERVER['HTTP_CLIENT_IP'])) $ip = $_SERVER['HTTP_CLIENT_IP'];
	} else {
		$ip = getenv('REMOTE_ADDR');
		if (getenv('HTTP_X_FORWARDED_FOR')) $ip = getenv('HTTP_X_FORWARDED_FOR');
		elseif (getenv('HTTP_CLIENT_IP')) $ip = getenv('HTTP_CLIENT_IP');
	}
	$ip = htmlspecialchars($ip, ENT_QUOTES, 'UTF-8');
	return $ip;
}
